/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import filenet.vw.toolkit.utils.mapui.VWImageAttrUI;
import filenet.vw.toolkit.utils.mapui.VWLabelUI;
import filenet.vw.toolkit.utils.mapui.VWMapNodeUIToolkit;
import filenet.vw.toolkit.utils.mapui.VWMilestoneUI;
import filenet.vw.toolkit.utils.mapui.VWRouteBubbleRenderer;
import filenet.vw.toolkit.utils.mapui.VWTextAttrUI;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.VWImageIcon;
import filenet.vw.toolkit.utils.wfdefinition.IVWMapNodeContainer;
import java.awt.AWTEventMulticaster;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class VWBaseStepUI
extends JComponent
implements IVWSelectWorkflowItem,
IVWMapNodeContainer {
    public static final int MODE_NUM = 5;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SELECTED = 1;
    public static final int MODE_FOCUS = 2;
    public static final int MODE_HOVER = 3;
    public static final int MODE_START = 4;
    public static final Dimension s_imageDim = new Dimension(40, 40);
    protected static final int s_nameYPixelOffset = 2;
    protected static final int s_maxDisplayNameLen = 40;
    protected static Point m_stepOffset = null;
    private FocusListener m_focusListeners = null;
    protected VWMapNode m_mapNode = null;
    private int m_nMode = 0;
    private boolean m_bStartStep = false;
    private Hashtable m_nextRoutes = new Hashtable();
    private Hashtable m_prevRoutes = new Hashtable();
    private Hashtable m_associations = new Hashtable();
    protected int m_namePixelWidth = 150;
    protected int m_namePixelHeight = 25;
    protected int m_nameOffset = 0;
    protected VWLabelUI m_label = null;
    protected VWMilestoneUI m_preMilestoneUI = null;
    protected VWMilestoneUI m_postMilestoneUI = null;
    protected Image m_collectorImage = null;
    protected Image m_splitorImage = null;
    protected Image[] m_stepImages = null;
    protected VWMapNodeUIToolkit m_vwMapNodeUIToolkit = null;
    protected VWRouteBubbleRenderer m_routeBubbleRenderer = null;

    public VWBaseStepUI(VWMapNode mapNode, boolean bLaunchStep, VWMapNodeUIToolkit vwMapNodeUIToolkit) {
        this(mapNode, bLaunchStep, bLaunchStep, vwMapNodeUIToolkit);
    }

    public VWBaseStepUI(VWMapNode mapNode, boolean bStartStep, boolean bLaunchStep, VWMapNodeUIToolkit vwMapNodeUIToolkit) {
        VWDebug.nullCheck(mapNode);
        this.m_mapNode = mapNode;
        this.m_bStartStep = bStartStep;
        this.m_vwMapNodeUIToolkit = vwMapNodeUIToolkit;
        this.m_routeBubbleRenderer = new VWRouteBubbleRenderer(this);
    }

    public Point getBoundaryPoint(double angle, boolean bUseMilestones) {
        Point loc = this.getLocation();
        Point p = new Point();
        double tan = Math.tan(angle);
        double width = VWBaseStepUI.s_imageDim.width;
        double height = VWBaseStepUI.s_imageDim.height;
        double mh = VWMilestoneUI.s_imageDim.height;
        double mw = VWMilestoneUI.s_imageDim.width;
        if (angle <= 0.7853981633974483 && angle >= -0.7853981633974483) {
            double H;
            p.y = (int)((double)(loc.y + VWBaseStepUI.s_imageDim.height / 2) + width / 2.0 * tan);
            p.x = loc.x + (int)width;
            if (bUseMilestones && this.checkPostMilestone() && (H = width / 2.0 * tan) < mh / 2.0 && H > -mh / 2.0) {
                double W = width / 2.0 + 2.0 + mw;
                H = W * tan;
                if (H > mh / 2.0 && H < height / 2.0) {
                    H = mh / 2.0;
                    W = H / tan;
                } else if (H < -mh / 2.0 && H > -height / 2.0) {
                    H = -mh / 2.0;
                    W = H / tan;
                }
                p.x = (int)((double)loc.x + width / 2.0 + W);
                p.y = (int)((double)loc.y + height / 2.0 + H);
            }
        } else if (angle < -2.356194490192345 || angle > 2.356194490192345) {
            double H;
            p.y = (int)((double)(loc.y + VWBaseStepUI.s_imageDim.height / 2) - width / 2.0 * tan);
            p.x = loc.x - 1;
            if (bUseMilestones && this.checkPreMilestone() && (H = -width / 2.0 * tan) < mh / 2.0 && H > -mh / 2.0) {
                double W = -(width / 2.0 + 2.0 + mw);
                H = W * tan;
                if (H > mh / 2.0 && H < height / 2.0) {
                    H = mh / 2.0;
                    W = H / tan;
                } else if (H < -mh / 2.0 && H > -height / 2.0) {
                    H = -mh / 2.0;
                    W = H / tan;
                }
                p.x = (int)((double)loc.x + width / 2.0 + W);
                p.y = (int)((double)loc.y + height / 2.0 + H);
            }
        } else if (angle > 0.0) {
            p.x = (int)((double)loc.x + width / 2.0 + (double)VWBaseStepUI.s_imageDim.height / (2.0 * tan));
            p.y = loc.y + VWBaseStepUI.s_imageDim.height;
        } else {
            p.x = (int)((double)loc.x + width / 2.0 - (double)VWBaseStepUI.s_imageDim.height / (2.0 * tan));
            p.y = loc.y - 1;
        }
        return p;
    }

    public boolean contains(Point loc) {
        if (loc.x >= this.getImageX() && loc.x <= this.getImageX() + VWBaseStepUI.s_imageDim.width && loc.y >= this.getImageY() && loc.y <= this.getImageY() + VWBaseStepUI.s_imageDim.height) {
            return true;
        }
        int x = 0;
        int y = 0;
        int w = VWBaseStepUI.s_imageDim.width;
        int h = 0;
        int mh = VWMilestoneUI.s_imageDim.height;
        int mw = VWMilestoneUI.s_imageDim.width;
        Point p = this.getLocation();
        if (this.checkPostMilestone()) {
            w += 2 + mw;
            x = p.x;
            h = mh;
            y = p.y + VWBaseStepUI.s_imageDim.height / 2 - mh / 2;
        }
        if (this.checkPreMilestone()) {
            w += 2 + mw;
            x = p.x - 2 - mw;
            h = mh;
            y = p.y + VWBaseStepUI.s_imageDim.height / 2 - mh / 2;
        }
        return h != 0 && loc.x >= x && loc.x <= x + w && loc.y >= y && loc.y <= y + h;
    }

    public Rectangle getBounds() {
        Rectangle rect = this.getImageBounds();
        Rectangle bubbleRect = this.m_routeBubbleRenderer.getBounds();
        if (bubbleRect != null) {
            rect = rect.union(bubbleRect);
        }
        if (this.checkPreMilestone()) {
            rect.width = rect.width + VWMilestoneUI.s_imageDim.width + 2;
            rect.x = rect.x - VWMilestoneUI.s_imageDim.width - 2;
        }
        if (this.checkPostMilestone()) {
            rect.width = rect.width + VWMilestoneUI.s_imageDim.width + 2;
        }
        this.createLabel(null);
        if (this.m_namePixelWidth > rect.width) {
            rect.x -= (this.m_namePixelWidth - rect.width) / 2;
            rect.width = this.m_namePixelWidth;
        }
        rect.height += this.m_namePixelHeight;
        return rect;
    }

    public Rectangle getImageBounds() {
        return new Rectangle(this.getLocation(), s_imageDim);
    }

    public void setLocation(Point loc) {
        if (this.m_mapNode != null) {
            this.m_mapNode.setLocation(loc);
        }
        super.setLocation(loc);
    }

    public int getImageX() {
        return this.getX();
    }

    public int getImageY() {
        return this.getY();
    }

    public Point getImageCenterLocation() {
        Point loc = this.getLocation();
        loc.x += VWBaseStepUI.s_imageDim.width / 2;
        loc.y += VWBaseStepUI.s_imageDim.height / 2;
        return loc;
    }

    public Point getImageBottomRightLoc() {
        Point pt = this.getLocation();
        pt.x += VWBaseStepUI.s_imageDim.width;
        pt.y += VWBaseStepUI.s_imageDim.height;
        return pt;
    }

    public VWRouteBubbleRenderer getRouteBubbleRenderer() {
        return this.m_routeBubbleRenderer;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.add(this.m_focusListeners, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.remove(this.m_focusListeners, l);
    }

    public boolean getFocus() {
        return this.m_nMode == 2;
    }

    public void setFocus(boolean bFocus) {
        if (bFocus) {
            if (this.m_nMode == 2) {
                return;
            }
            this.m_nMode = 2;
            if (this.m_focusListeners != null) {
                this.m_focusListeners.focusGained(new FocusEvent(this, 1004));
            }
        } else {
            this.m_nMode = 0;
            if (this.m_focusListeners != null) {
                this.m_focusListeners.focusLost(new FocusEvent(this, 1005));
            }
        }
    }

    public boolean getSelect() {
        return this.m_nMode == 1 || this.m_nMode == 2;
    }

    public void setSelect(boolean bSelect) {
        this.m_nMode = bSelect ? 1 : 0;
    }

    public void setMode(int nMode) {
        switch (nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_nMode = nMode;
                this.m_routeBubbleRenderer.reset();
            }
        }
    }

    public boolean captureFocus(Point loc) {
        boolean bResult = false;
        if (this.contains(loc)) {
            this.setFocus(true);
            bResult = true;
        }
        return bResult;
    }

    public void paintComponent(Graphics g) {
        int imageX = this.getImageX();
        int imageY = this.getImageY();
        boolean bFocus = this.getFocus();
        boolean bSelect = this.getSelect();
        if (this.checkPreMilestone()) {
            if (this.m_preMilestoneUI == null) {
                this.m_preMilestoneUI = new VWMilestoneUI(0, (VWStepDefinition)this.m_mapNode, imageX, imageY, VWBaseStepUI.s_imageDim.width, VWBaseStepUI.s_imageDim.height, this.getFocus(), this.getSelect());
            } else {
                this.m_preMilestoneUI.init(imageX, imageY + VWBaseStepUI.s_imageDim.height / 2, bFocus, bSelect);
            }
            this.m_preMilestoneUI.paintComponent(g);
        }
        if (this.checkPostMilestone()) {
            if (this.m_postMilestoneUI == null) {
                this.m_postMilestoneUI = new VWMilestoneUI(1, (VWStepDefinition)this.m_mapNode, imageX, imageY, VWBaseStepUI.s_imageDim.width, VWBaseStepUI.s_imageDim.height, this.getFocus(), this.getSelect());
            } else {
                this.m_postMilestoneUI.init(imageX, imageY + VWBaseStepUI.s_imageDim.height / 2, bFocus, bSelect);
            }
            this.m_postMilestoneUI.paintComponent(g);
        }
        this.createLabel(g);
        this.m_label.paintComponent(g, new Point(VWBaseStepUI.s_imageDim.width / 2 + imageX, imageY + VWBaseStepUI.s_imageDim.height + g.getFontMetrics().getHeight()), false);
        this.m_routeBubbleRenderer.paintComponent(g);
        if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            Image img = this.getImage();
            int dx1 = VWBaseStepUI.s_imageDim.width + imageX;
            int dy1 = imageY;
            int dx2 = imageX;
            int dy2 = VWBaseStepUI.s_imageDim.height + imageY;
            int sx1 = 0;
            int sy1 = 0;
            int sx2 = VWBaseStepUI.s_imageDim.width;
            int sy2 = VWBaseStepUI.s_imageDim.height;
            g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
        } else {
            g.drawImage(this.getImage(), imageX, imageY, VWBaseStepUI.s_imageDim.width, VWBaseStepUI.s_imageDim.height, this);
        }
    }

    public void printComponent(Graphics2D g2, PageFormat pf, int pi, int wp, int hp) throws PrinterException {
        int row = pi / wp;
        int col = pi % wp;
        double iW = pf.getImageableWidth();
        double iH = pf.getImageableHeight();
        int pageX = (int)Math.round((double)col * iW);
        int pageY = (int)Math.round((double)row * iH);
        int pageX2 = pageX + (int)iW;
        int pageY2 = pageY + (int)iH;
        int imageXul = this.getImageX();
        int imageYul = this.getImageY();
        int imageXlr = imageXul + VWBaseStepUI.s_imageDim.width;
        int imageYlr = imageYul + VWBaseStepUI.s_imageDim.height;
        if (imageXul >= pageX && imageXul <= pageX2 && imageYul >= pageY && imageYul <= pageY2 || imageXlr >= pageX && imageXlr <= pageX2 && imageYlr >= pageY && imageYlr <= pageY2) {
            g2.drawImage(this.getPrinterImage(), imageXul - pageX, imageYul - pageY, VWBaseStepUI.s_imageDim.width, VWBaseStepUI.s_imageDim.height, this);
        }
        Point centerPt = new Point(VWBaseStepUI.s_imageDim.width / 2 + imageXul, imageYul + VWBaseStepUI.s_imageDim.height + g2.getFontMetrics().getHeight());
        this.createLabel(g2);
        this.m_label.printComponent(g2, centerPt, pageX, pageY, pageX2, pageY2, false);
        if (this.checkPreMilestone() && this.m_preMilestoneUI != null) {
            this.m_preMilestoneUI.printComponent(g2, pf, pi, wp, hp);
        }
        if (this.checkPostMilestone() && this.m_postMilestoneUI != null) {
            this.m_postMilestoneUI.printComponent(g2, pf, pi, wp, hp);
        }
    }

    public void printProperty(Graphics g, PageFormat pf) throws PrinterException {
    }

    public void dragTo(Point loc) {
        VWBaseRouteUI route;
        this.setLocation(loc);
        Enumeration e = this.getNextRoutes();
        while (e.hasMoreElements()) {
            route = (VWBaseRouteUI)e.nextElement();
            route.recalcPosition();
        }
        e = this.getPrevRoutes();
        while (e.hasMoreElements()) {
            route = (VWBaseRouteUI)e.nextElement();
            route.recalcPosition();
        }
        e = this.getAssociations();
        while (e.hasMoreElements()) {
            VWBaseAssociationUI association = (VWBaseAssociationUI)e.nextElement();
            association.recalcPosition();
        }
    }

    public Enumeration getNextRoutes() {
        return this.m_nextRoutes.keys();
    }

    public void addNextRoute(VWBaseRouteUI nextRoute, VWBaseStepUI destStep) {
        this.addRoute(this.m_nextRoutes, nextRoute, destStep);
    }

    public void removeNextRoute(VWBaseRouteUI nextRoute) {
        this.removeRoute(this.m_nextRoutes, nextRoute);
    }

    public Enumeration getPrevRoutes() {
        return this.m_prevRoutes.keys();
    }

    public void addPrevRoute(VWBaseRouteUI prevRoute, VWBaseStepUI prevStep) {
        this.addRoute(this.m_prevRoutes, prevRoute, prevStep);
    }

    public void removePrevRoute(VWBaseRouteUI nextRoute) {
        this.removeRoute(this.m_prevRoutes, nextRoute);
    }

    private void addRoute(Hashtable routes, VWBaseRouteUI route, VWBaseStepUI step) {
        if (!routes.containsKey(route)) {
            routes.put(route, step);
        } else {
            VWDebug.logError(VWResource.s_routeAlreadyExists);
        }
    }

    private void removeRoute(Hashtable routes, VWBaseRouteUI route) {
        if (routes.remove(route) == null) {
            VWDebug.logError(VWResource.s_cannotRemoveNonExistingRoute);
        }
    }

    public boolean hasARouteToStep(VWBaseStepUI toStep) {
        boolean bResult = false;
        Enumeration e = this.getNextRoutes();
        while (e.hasMoreElements()) {
            VWBaseRouteUI route = (VWBaseRouteUI)e.nextElement();
            if (route.getDestStep() != toStep) continue;
            bResult = true;
        }
        return bResult;
    }

    public Enumeration getAssociations() {
        if (this.m_associations == null) {
            this.m_associations = new Hashtable();
        }
        return this.m_associations.keys();
    }

    public void addAssociation(VWBaseAssociationUI association, VWBaseTextAnnotationUI textAnnotation) {
        if (!this.m_associations.containsKey(association)) {
            this.m_associations.put(association, textAnnotation);
        } else {
            VWDebug.logError("The association already exists.");
        }
    }

    public void removeAssociation(VWBaseAssociationUI association) {
        if (this.m_associations.remove(association) == null) {
            VWDebug.logError("The association does not exist. Cannot remove.");
        }
    }

    public VWMapNode getMapNode() {
        return this.m_mapNode;
    }

    public boolean isStartStep() {
        return this.m_bStartStep;
    }

    public void reloadStepImages() {
        this.loadStepImages();
    }

    public void replace(VWBaseStepUI newStepUI) {
        VWBaseRouteUI route;
        Enumeration e = this.getNextRoutes();
        while (e.hasMoreElements()) {
            route = (VWBaseRouteUI)e.nextElement();
            VWBaseStepUI toStepUI = route.getDestStep();
            newStepUI.addNextRoute(route, toStepUI);
            route.replaceSrcStep(newStepUI);
        }
        e = this.getPrevRoutes();
        while (e.hasMoreElements()) {
            route = (VWBaseRouteUI)e.nextElement();
            VWBaseStepUI fromStepUI = route.getSrcStep();
            newStepUI.addPrevRoute(route, fromStepUI);
            route.replaceDestStep(newStepUI);
        }
    }

    public void removeReferences() {
        this.m_focusListeners = null;
        this.m_mapNode = null;
        if (this.m_nextRoutes != null) {
            this.m_nextRoutes.clear();
            this.m_nextRoutes = null;
        }
        if (this.m_prevRoutes != null) {
            this.m_prevRoutes.clear();
            this.m_prevRoutes = null;
        }
        if (this.m_associations != null) {
            this.m_associations.clear();
            this.m_associations = null;
        }
        this.m_label = null;
        this.m_preMilestoneUI = null;
        this.m_postMilestoneUI = null;
        this.m_collectorImage = null;
        this.m_stepImages = null;
    }

    public abstract int getStepType();

    protected abstract void loadStepImages();

    protected void init() {
        this.loadStepImages();
        this.loadCollectorImage();
        this.loadSplitorImage();
        VWDebug.nullCheck(this.m_stepImages);
        if (this.m_mapNode.getLocation() == null) {
            this.setLocation(new Point(50, 50));
        } else {
            this.setLocation(this.m_mapNode.getLocation());
        }
        this.m_label = new VWLabelUI();
    }

    protected Image getImage() {
        if (this.m_stepImages != null) {
            if ((this.m_routeBubbleRenderer.displayHoverIcon() || this.m_nMode == 3) && this.m_stepImages[3] != null) {
                return this.m_stepImages[3];
            }
            if (this.getFocus()) {
                return this.m_stepImages[2];
            }
            if (this.getSelect()) {
                return this.m_stepImages[1];
            }
            if (this.m_bStartStep && this.m_stepImages[4] != null) {
                return this.m_stepImages[4];
            }
            return this.m_stepImages[0];
        }
        return null;
    }

    protected Image getPrinterImage() {
        if (this.m_bStartStep && this.m_stepImages[4] != null) {
            return this.m_stepImages[4];
        }
        return this.m_stepImages[0];
    }

    protected boolean isStopStep() {
        return this.m_nextRoutes.size() == 0;
    }

    protected void loadCollectorImage() {
        ImageIcon imageIcon;
        if (this.m_collectorImage == null && (imageIcon = VWImageLoader.createImageIcon("collector.gif")) != null) {
            this.m_collectorImage = imageIcon.getImage();
        }
    }

    protected void loadSplitorImage() {
        ImageIcon imageIcon;
        if (this.m_splitorImage == null && (imageIcon = VWImageLoader.createImageIcon("splitor.gif")) != null) {
            this.m_splitorImage = imageIcon.getImage();
        }
    }

    protected Image[] loadCustomImages(boolean bStartStep) {
        String customStepIconName = this.getCustomStepIconName(bStartStep);
        if (customStepIconName != null && customStepIconName.length() > 0) {
            Image[] images = new Image[5];
            this.loadExternalImages(images, customStepIconName);
            boolean bFound = true;
            for (int i = 0; i < 5; ++i) {
                if (images[i] != null) continue;
                bFound = false;
                break;
            }
            if (bFound) {
                return images;
            }
        }
        return null;
    }

    protected void loadImages(Image[] images, String imageName) {
        if (images != null && images.length >= 5) {
            images[2] = null;
            images[1] = null;
            images[0] = null;
            images[3] = null;
            images[4] = null;
            ImageIcon imageIcon = VWImageLoader.createImageIcon(imageName + "_f.gif");
            if (imageIcon != null) {
                images[2] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_s.gif")) != null) {
                images[1] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_n.gif")) != null) {
                images[0] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_h.gif")) != null) {
                images[3] = imageIcon.getImage();
            }
            if ((imageIcon = VWImageLoader.createImageIcon(imageName + "_st.gif")) != null) {
                images[4] = imageIcon.getImage();
            }
        }
    }

    protected void loadExternalImages(Image[] images, String imageName) {
        if (images != null && images.length >= 5) {
            images[2] = null;
            images[1] = null;
            images[0] = null;
            images[3] = null;
            images[4] = null;
            ClassLoader externalClassLoader = this.m_vwMapNodeUIToolkit.getExternalClassLoader();
            VWImageIcon imageIcon = null;
            URL imageURL = externalClassLoader.getResource(imageName + "_f.gif");
            if (imageURL != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                images[2] = imageIcon.getImage();
            }
            if ((imageURL = externalClassLoader.getResource(imageName + "_s.gif")) != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                images[1] = imageIcon.getImage();
            }
            if ((imageURL = externalClassLoader.getResource(imageName + "_n.gif")) != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                images[0] = imageIcon.getImage();
            }
            if ((imageURL = externalClassLoader.getResource(imageName + "_h.gif")) != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                images[3] = imageIcon.getImage();
            }
            if ((imageURL = externalClassLoader.getResource(imageName + "_st.gif")) != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                images[4] = imageIcon.getImage();
            }
        }
    }

    protected void createLabel(Graphics g) {
        try {
            this.m_label.removeAllAttributes();
            VWLabelUI labelUI = new VWLabelUI();
            if (this.m_mapNode != null) {
                Graphics graphics;
                String label;
                if (this.m_mapNode != null && this.m_mapNode.getSplitType() == 1) {
                    if (this.m_vwMapNodeUIToolkit.getMapAttribs().isCollectorAttrsVisible()) {
                        this.m_label.addAttribute(new VWImageAttrUI(this.m_splitorImage));
                    }
                    labelUI.addAttribute(new VWImageAttrUI(this.m_splitorImage));
                }
                if (this.m_mapNode != null && this.m_mapNode.getJoinType() == 1) {
                    if (this.m_vwMapNodeUIToolkit.getMapAttribs().isCollectorAttrsVisible()) {
                        this.m_label.addAttribute(new VWImageAttrUI(this.m_collectorImage));
                    }
                    labelUI.addAttribute(new VWImageAttrUI(this.m_collectorImage));
                }
                if ((label = this.m_mapNode.getName()) != null) {
                    if (label.length() > 40) {
                        label = label.substring(0, 39);
                    }
                    if (this.m_vwMapNodeUIToolkit.getMapAttribs().isStepNameVisible()) {
                        this.m_label.addAttribute(new VWTextAttrUI(label));
                    }
                    labelUI.addAttribute(new VWTextAttrUI(label));
                }
                Graphics graphics2 = graphics = g == null ? this.getGraphics() : g;
                if (graphics != null) {
                    this.m_namePixelWidth = labelUI.getWidth(g) + 20;
                    this.m_nameOffset = (VWBaseStepUI.s_imageDim.width - this.m_namePixelWidth) / 2;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean checkPreMilestone() {
        boolean bResult = false;
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        if (stepType == 0 || VWStepUtils.isGeneralStep(stepType) || VWStepUtils.isStartGeneralStep(stepType)) {
            VWStepDefinition stepDef = (VWStepDefinition)this.m_mapNode;
            bResult = stepDef.getPreMilestone() != null;
        }
        return bResult && this.m_vwMapNodeUIToolkit.getMapAttribs().isMilestoneVisible();
    }

    private boolean checkPostMilestone() {
        boolean bResult = false;
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        if (stepType == 0 || VWStepUtils.isGeneralStep(stepType) || VWStepUtils.isStartGeneralStep(stepType)) {
            VWStepDefinition stepDef = (VWStepDefinition)this.m_mapNode;
            bResult = stepDef.getPostMilestone() != null;
        }
        return bResult && this.m_vwMapNodeUIToolkit.getMapAttribs().isMilestoneVisible();
    }

    private String getCustomStepIconName(boolean isStartStep) {
        String imageName = null;
        if (this.m_mapNode != null) {
            try {
                Object obj;
                VWAttributeInfo attribute = this.m_mapNode.getAttributeInfo();
                if (attribute != null && (obj = attribute.getFieldValue("UI_IconName")) != null && obj instanceof String) {
                    imageName = (String)obj;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return imageName;
    }
}

